using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nocnvoznja
{
    class Cvor
    {
        public int podatak;
        public Cvor sledeci;
        public Grana grane;
        public int status;
        public int brojraskrsnica;

        public Cvor(int podatak)
        {
            this.podatak = podatak;
            this.sledeci = null;
            this.grane = null;
            this.status = 0;
            this.brojraskrsnica = 0;
        }

        public Cvor(Cvor c)
        {
            this.podatak = c.podatak;
            this.sledeci = c.sledeci;
            this.grane = c.grane;
            this.status = c.status;
            this.brojraskrsnica = c.brojraskrsnica;
        }

        public void prikazi()
        {
            if (this != null)
                Console.Write("{0} ", this.podatak);
        }

        public int vratipodatak()
        {
            return podatak;
        }
    }

    class Grana
    {
        public Cvor odrediste;
        public Grana sledeca;

        public Grana(Cvor odrediste)
        {
            this.odrediste = odrediste;
            this.sledeca = null;
        }
    }

    class graf
    {
        int brojcvorova;
        Cvor pocetni;
        Cvor poslednji;
        public int vratibrojcvorova()
        {
            return brojcvorova;
        }

        public Cvor vratipocetni()
        {
            return pocetni;
        }

        public Cvor vratiposlednji()
        {
            return poslednji;
        }
        public void dodajcvor(int podatak)
        {
            if (vraticvor(podatak) == null)
            {
                Cvor novi = new Cvor(podatak);
                if (pocetni == null)
                    pocetni = novi;
                else
                {
                    Cvor trenutni = pocetni;
                    while (trenutni.sledeci != null)
                    {
                        trenutni = trenutni.sledeci;
                    }
                    trenutni.sledeci = novi;
                }
                poslednji = novi;
                brojcvorova++;
            }
        }

        public Cvor vraticvor(int p)
        {
            Cvor trenutni = pocetni;
            while (trenutni != null && trenutni.podatak != p)
            {
                trenutni = trenutni.sledeci;
            }
            if (trenutni != null)
                return trenutni;
            return null;
        }

        public Grana vratigranu(int pocetak, int kraj)
        {
            Cvor p = vraticvor(pocetak);
            Cvor k = vraticvor(kraj);
            if (p == null || k == null)
                return null;
            Grana grane = p.grane;
            while (grane != null && grane.odrediste.podatak != kraj)
            {
                grane = grane.sledeca;
            }
            if (grane != null)
                return grane;
            return null;
        }

        public void dodajgranu(int pocetak, int kraj)
        {
            Cvor p = vraticvor(pocetak);
            Cvor k = vraticvor(kraj);
            Grana nova = new Grana(k);
            if (vratigranu(pocetak, kraj) == null && p != null && k != null)
            {
                if (p.grane == null)
                {
                    p.grane = nova;
                }
                else
                {
                    Grana grane = p.grane;
                    while (grane.sledeca != null)
                    {
                        grane = grane.sledeca;
                    }
                    grane.sledeca = nova;
                }

            }
        }

        /*public void prikazigraf()
        {
            Cvor cvor = pocetni;
            while (cvor != null)
            {
                Grana grana = cvor.grane;
                Console.Write("{0} ", cvor.podatak);
                while (grana != null)
                {
                    Console.Write("-> {0} ", grana.odrediste.podatak);
                    grana = grana.sledeca;
                }
                Console.WriteLine();
                cvor = cvor.sledeci;
            }
        }*/

        public void nadjiput(int p, ref int[,] m1, int j)
        {
            LinkedList<Cvor> red = new LinkedList<Cvor>();
            Cvor cvor = pocetni;
            while (cvor != null)
            {
                cvor.brojraskrsnica = 0;
                cvor.status = 0;
                cvor = cvor.sledeci;
            }
            int brojobidjennih = 0;
            cvor = vraticvor(p);
            red.AddLast(cvor);
            cvor.status = 1;
            while (red.Count != 0)
            {
                cvor = red.First();
                brojobidjennih++;
                m1[cvor.vratipodatak(), j] = cvor.brojraskrsnica;
                red.RemoveFirst();
                cvor.status = 2;
                Grana grane = cvor.grane;
                while (grane != null)
                {
                    if (grane.odrediste.status == 0)
                    {
                        grane.odrediste.status = 1;
                        grane.odrediste.brojraskrsnica = cvor.brojraskrsnica + 1;
                        red.AddLast(grane.odrediste);
                    }
                    grane = grane.sledeca;
                }
            }
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            int n;
            n = int.Parse(Console.ReadLine());
            string l = Console.ReadLine();
            string[] r = l.Split(' ');
            int i;
            graf graf1 = new graf();
            Cvor[] niz = new Cvor[n];
            for (i = 1; i <= n; i++)
            {
                int a = int.Parse(r[i-1]);
                graf1.dodajcvor(a);
                niz[i-1] = graf1.vratiposlednji();
            }
            for (i = 1; i < n; i++)
            {
                l = Console.ReadLine();
                r = l.Split(' ');
                int a = int.Parse(r[0]);
                int b = int.Parse(r[1]);
                graf1.dodajgranu(a, b);
                graf1.dodajgranu(b, a);
            }

            int q;
            q = int.Parse(Console.ReadLine());
            int[,] m;
            m = new int[q, 4];
            int br = 0;
            for (i = 0; i < q; i++)
            {
                l = Console.ReadLine();
                r = l.Split(' ');
                m[i, 0] = int.Parse(r[0]);
                m[i, 1] = int.Parse(r[1]);
                m[i, 2] = int.Parse(r[2]);
                if (m[i,0] == 2)
                {
                    m[i, 3] = int.Parse(r[3]);
                    br++;
                }
            }
            int[,] m1;
            m1 = new int[n + 1, br];
            int br1 = 0;
            for (i = 0; i < q; i++)
            {
                if (m[i, 0] == 1) 
                {
                    Cvor p = niz[m[i, 1] - 1];
                    niz[m[i, 1] - 1] = niz[m[i, 2] - 1];
                    niz[m[i, 2] - 1] = p;
                }
                else
                {
                    int j;
                    bool t = true;
                    for (j = 0; j < br1 && t; j++)
                    {
                        if (m1[0, j] == m[i, 3])
                            t = false;
                    }
                    if (t)
                    {
                        m1[0, br1] = m[i, 3];
                        graf1.nadjiput(m[i, 3], ref m1, br1);
                        br1++;
                    }
                    else
                        j--;
                    int ma = 0;
                    int k;
                    for (k = m[i, 1] - 1; k <= m[i, 2] - 1; k++)
                    {
                        if (m1[niz[k].vratipodatak(), j] > ma) 
                            ma = m1[niz[k].vratipodatak(), j];
                    }
                    Console.WriteLine(ma);
                }
            }
        }
    }
}